import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';
import 'package:viser_remit/data/services/api_client.dart';

import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/my_images.dart';
import '../../../../../core/utils/my_strings.dart';
import '../../../../../core/utils/style.dart';

class DashBoardCardSection extends StatelessWidget {
  final HomeController controller;

  const DashBoardCardSection({super.key, required this.controller});

  @override
  Widget build(BuildContext context) {
    double elevation = 0.9;
    double cardBorderRadius = 10;
    var apiClient = Get.find<ApiClient>();

    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 8,vertical: 8),
      decoration: BoxDecoration(
        color: MyColor.colorWhite,
        borderRadius: BorderRadius.circular(8)
      ),
      child: Column(
        children: [
          Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Expanded(
                  child: Card(
                    elevation: elevation,
                    shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(cardBorderRadius)),
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(cardBorderRadius),
                      child: Container(
                        padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
                        decoration: const BoxDecoration(
                            border: Border(
                                left: BorderSide(
                          width: 2,
                          color: MyColor.primaryColor,
                        ))),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Container(
                                  width: Dimensions.space36,
                                  height: Dimensions.space36,
                                  decoration: BoxDecoration(color: MyColor.greenSuccessColor, borderRadius: BorderRadius.circular(100)),
                                  padding: const EdgeInsets.all(Dimensions.space10),
                                  child: SvgPicture.asset(
                                    MyImages.wallet,
                                    colorFilter: const ColorFilter.mode(MyColor.colorWhite, BlendMode.srcIn),
                                  ),
                                ),
                                const SizedBox(width: Dimensions.space8),
                                Expanded(
                                  child: Column(
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        MyStrings.refundWalletBalance.tr,
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: regularDefault.copyWith(color: MyColor.textColor),
                                      ),
                                      const SizedBox(
                                        height: Dimensions.space8,
                                      ),
                                      Text(
                                        "${apiClient.getCurrencyOrUsername(isSymbol: true)}${controller.balance}",
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: regularDefault.copyWith(
                                          fontWeight: FontWeight.w600,
                                          fontSize: Dimensions.fontLarge,
                                          color: MyColor.textColor,
                                        ),
                                      )
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  ),
                ),
                const SizedBox(width: Dimensions.dashBoardHorizontalSpace),
                Expanded(
                  child: Card(
                    elevation: elevation,
                    shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(cardBorderRadius)),
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(cardBorderRadius),
                      child: Container(
                        padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
                        decoration: const BoxDecoration(
                          border: Border(left: BorderSide(width: 2, color: MyColor.primaryColor)),
                        ),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Container(
                                  width: Dimensions.space36,
                                  height: Dimensions.space36,
                                  decoration: BoxDecoration(color: MyColor.greenSuccessColor, borderRadius: BorderRadius.circular(100)),
                                  padding: const EdgeInsets.all(Dimensions.space10),
                                  child: SvgPicture.asset(
                                    MyImages.sendMoneyCompleted,
                                    colorFilter: const ColorFilter.mode(MyColor.colorWhite, BlendMode.srcIn),
                                  ),
                                ),
                                const SizedBox(width: Dimensions.space8),
                                Expanded(
                                  child: Column(
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        MyStrings.sendMoneyCompleted.tr,
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: regularDefault.copyWith(color: MyColor.textColor),
                                      ),
                                      const SizedBox(
                                        height: Dimensions.space8,
                                      ),
                                      Text(
                                        "${apiClient.getCurrencyOrUsername(isSymbol: true)}${controller.sendMoneyAmount}",
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: regularDefault.copyWith(
                                          fontWeight: FontWeight.w600,
                                          fontSize: Dimensions.fontLarge,
                                          color: MyColor.textColor,
                                        ),
                                      )
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  ),
                ),
              ],
            ),
            const SizedBox(
              height: 7,
            ),
            Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Expanded(
                  child: Card(
                    elevation: elevation,
                    shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(cardBorderRadius)),
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(cardBorderRadius),
                      child: Container(
                        padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
                        decoration: const BoxDecoration(
                            border: Border(
                                left: BorderSide(
                          width: 2,
                          color: MyColor.primaryColor,
                        ))),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Container(
                                  width: Dimensions.space36,
                                  height: Dimensions.space36,
                                  decoration: BoxDecoration(color: MyColor.pendingColor, borderRadius: BorderRadius.circular(100)),
                                  padding: const EdgeInsets.all(Dimensions.space10),
                                  child: SvgPicture.asset(
                                    MyImages.sendMoneyPending,
                                    width: 20,
                                    height: 20,
                                    colorFilter: const ColorFilter.mode(MyColor.colorWhite, BlendMode.srcIn),
                                  ),
                                ),
                                const SizedBox(width: Dimensions.space8),
                                Expanded(
                                  child: Column(
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        MyStrings.sendMoneyPending.tr,
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: regularDefault.copyWith(color: MyColor.textColor),
                                      ),
                                      const SizedBox(
                                        height: Dimensions.space8,
                                      ),
                                      Text(
                                        "${apiClient.getCurrencyOrUsername(isSymbol: true)}${controller.sendMoneyPending}",
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: regularDefault.copyWith(
                                          fontWeight: FontWeight.w600,
                                          fontSize: Dimensions.fontLarge,
                                          color: MyColor.textColor,
                                        ),
                                      )
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  ),
                ),
                const SizedBox(
                  width: Dimensions.dashBoardHorizontalSpace,
                ),
                Expanded(
                  child: Card(
                    elevation: elevation,
                    shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(cardBorderRadius)),
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(cardBorderRadius),
                      child: Container(
                        padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
                        decoration: const BoxDecoration(
                            border: Border(
                                left: BorderSide(
                          width: 2,
                          color: MyColor.primaryColor,
                        ))),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Container(
                                  width: Dimensions.space36,
                                  height: Dimensions.space36,
                                  decoration: BoxDecoration(color: MyColor.primaryColor, borderRadius: BorderRadius.circular(100)),
                                  padding: const EdgeInsets.all(Dimensions.space10),
                                  child: SvgPicture.asset(
                                    MyImages.sendMoneyInitiated,
                                    width: 20,
                                    height: 20,
                                    colorFilter: const ColorFilter.mode(MyColor.colorWhite, BlendMode.srcIn),
                                  ),
                                ),
                                const SizedBox(width: Dimensions.space8),
                                Expanded(
                                  child: Column(
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        MyStrings.sendMoneyInitiated.tr,
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: regularDefault.copyWith(color: MyColor.textColor),
                                      ),
                                      const SizedBox(
                                        height: Dimensions.space8,
                                      ),
                                      Text(
                                        "${apiClient.getCurrencyOrUsername(isSymbol: true)}${controller.sendMoneyInitiated}",
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                        style: regularDefault.copyWith(
                                          fontWeight: FontWeight.w600,
                                          fontSize: Dimensions.fontLarge,
                                          color: MyColor.textColor,
                                        ),
                                      )
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  ),
                ),
              ],
            ),
            Visibility(
              visible: controller.showDashBoardAllCard == false,
              child: Align(
                  alignment: Alignment.topRight,
                  child: GestureDetector(
                    onTap: () {
                      controller.changeDashBoardCardStatus(true);
                    },
                    child: Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 8, vertical: 5),
                      child: Text(
                        MyStrings.showMore.tr,
                        style: semiBoldDefault.copyWith(color: MyColor.primaryColor),
                      ),
                    ),
                  )),
            ),
            controller.showDashBoardAllCard ? const SizedBox(height: 7) : const SizedBox.shrink(),
            Visibility(
              visible: controller.showDashBoardAllCard,
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Expanded(
                    child: Card(
                      elevation: elevation,
                      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(cardBorderRadius)),
                      child: ClipRRect(
                        borderRadius: BorderRadius.circular(cardBorderRadius),
                        child: Container(
                          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
                          decoration: const BoxDecoration(
                            border: Border(left: BorderSide(width: 2, color: MyColor.primaryColor)),
                          ),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  Container(
                                    width: Dimensions.space36,
                                    height: Dimensions.space36,
                                    decoration: BoxDecoration(color: MyColor.pendingColor, borderRadius: BorderRadius.circular(100)),
                                    padding: const EdgeInsets.all(Dimensions.space10),
                                    child: SvgPicture.asset(
                                      MyImages.sendMoneyPending,
                                      width: 20,
                                      height: 20,
                                      colorFilter: const ColorFilter.mode(MyColor.colorWhite, BlendMode.srcIn),
                                    ),
                                  ),
                                  const SizedBox(width: Dimensions.space8),
                                  Expanded(
                                    child: Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: [
                                        Text(
                                          MyStrings.pendingPayment.tr,
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: regularDefault.copyWith(color: MyColor.textColor),
                                        ),
                                        const SizedBox(
                                          height: Dimensions.space8,
                                        ),
                                        Text(
                                          "${apiClient.getCurrencyOrUsername(isSymbol: true)}${controller.paymentPending}",
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: regularDefault.copyWith(
                                            fontWeight: FontWeight.w600,
                                            fontSize: Dimensions.fontLarge,
                                            color: MyColor.textColor,
                                          ),
                                        )
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ),
                      ),
                    ),
                  ),
                  const SizedBox(
                    width: Dimensions.dashBoardHorizontalSpace,
                  ),
                  Expanded(
                    child: Card(
                      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(cardBorderRadius)),
                      elevation: elevation,
                      child: ClipRRect(
                        borderRadius: BorderRadius.circular(cardBorderRadius),
                        child: Container(
                          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
                          decoration: const BoxDecoration(
                              border: Border(
                                  left: BorderSide(
                            width: 2,
                            color: MyColor.primaryColor,
                          ))),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                children: [
                                  Container(
                                    width: Dimensions.space36,
                                    height: Dimensions.space36,
                                    decoration: BoxDecoration(color: MyColor.dangerColor, borderRadius: BorderRadius.circular(100)),
                                    padding: const EdgeInsets.all(Dimensions.space10),
                                    child: SvgPicture.asset(
                                      MyImages.sendMoneyCancel,
                                      width: 20,
                                      height: 20,
                                      colorFilter: const ColorFilter.mode(MyColor.colorWhite, BlendMode.srcIn),
                                    ),
                                  ),
                                  const SizedBox(width: Dimensions.space8),
                                  Expanded(
                                    child: Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: [
                                        Text(
                                          MyStrings.rejectedPayment.tr,
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: regularDefault.copyWith(color: MyColor.textColor),
                                        ),
                                        const SizedBox(
                                          height: Dimensions.space8,
                                        ),
                                        Text(
                                          "${apiClient.getCurrencyOrUsername(isSymbol: true)}${controller.paymentRejected}",
                                          maxLines: 2,
                                          overflow: TextOverflow.ellipsis,
                                          style: regularDefault.copyWith(
                                            fontWeight: FontWeight.w600,
                                            fontSize: Dimensions.fontLarge,
                                            color: MyColor.textColor,
                                          ),
                                        )
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ),
            Visibility(
              //hello
              visible: controller.showDashBoardAllCard,
              child: Align(
                  alignment: Alignment.topRight,
                  child: GestureDetector(
                    onTap: () {
                      controller.changeDashBoardCardStatus(false);
                    },
                    child: Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 8, vertical: 5),
                      child: Text(
                        MyStrings.showLess.tr,
                        style: semiBoldDefault.copyWith(color: MyColor.primaryColor),
                      ),
                    ),
                  )),
            ),
          ]),
        ],
      ),
    );
  }
}
